/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class SlimesuitItem
extends ModifiableArmorItem {
    private static final Map<String, String> ARMOR_TEXTURE_CACHE = new HashMap<String, String>();
    private static final Map<String, String> LEG_TEXTURE_CACHE = new HashMap<String, String>();
    private static final Function<String, String> ARMOR_GETTER = mat -> SlimesuitItem.makeArmorTexture(mat, "layer_1");
    private static final Function<String, String> LEG_GETTER = mat -> SlimesuitItem.makeArmorTexture(mat, "layer_2");

    public SlimesuitItem(ModifiableArmorMaterial material, ArmorSlotType slotType, Item.Properties properties) {
        super(material, slotType, properties);
    }

    public static String getMaterial(ItemStack stack) {
        if (ModifierUtil.getModifierLevel(stack, TinkerModifiers.golden.getId()) > 0) {
            return MaterialIds.gold.toString();
        }
        String key = ModifierUtil.getPersistentString(stack, TinkerModifiers.embellishment.getId());
        if (key.isEmpty()) {
            return MaterialIds.enderslime.toString();
        }
        return key;
    }

    public static String makeArmorTexture(String material, String texture) {
        ResourceLocation location = ResourceLocation.m_135820_((String)material);
        if (location == null) {
            location = MaterialIds.enderslime;
        }
        return String.format("%s:textures/models/armor/slime/%s_%s_%s.png", "tconstruct", texture, location.m_135827_(), location.m_135815_());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        String material = SlimesuitItem.getMaterial(stack);
        if (slot == EquipmentSlot.LEGS) {
            return LEG_TEXTURE_CACHE.computeIfAbsent(material, LEG_GETTER);
        }
        return ARMOR_TEXTURE_CACHE.computeIfAbsent(material, ARMOR_GETTER);
    }
}

